/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.IVWSortTableColumn;
import filenet.vw.toolkit.utils.table.VWQuickTableSort;
import filenet.vw.toolkit.utils.table.VWTableMap;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VWTableSorter
extends VWTableMap {
    int[] indexes = null;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    protected int sortedColumn = 0;
    Vector tables = new Vector();
    IVWSortTableColumn iModel = null;
    private MouseAdapter m_listMouseListener = null;

    public VWTableSorter() {
        this.indexes = new int[0];
    }

    public VWTableSorter(TableModel model) {
        this.setModel(model);
    }

    public VWTableSorter(IVWSortTableColumn model) {
        this.iModel = model;
        this.setModel((TableModel)((Object)model));
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        Class<?> type = this.model.getColumnClass(column);
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s22;
            String s1 = (String)data.getValueAt(row1, column);
            int result = VWStringUtils.compareIgnoreCase(s1, s22 = (String)data.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = data.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = VWStringUtils.compareIgnoreCase(s1, s2 = (v2 = data.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public void tableChanged(TableModelEvent e) {
        if (this.indexes.length != this.model.getRowCount()) {
            this.reallocateIndexes();
        }
        boolean order = !this.ascending;
        super.tableChanged(e);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            this.tableChanged(new TableModelEvent(this));
        }
    }

    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
        this.tableChanged(new TableModelEvent(this));
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        Enumeration enum1 = this.tables.elements();
        while (enum1.hasMoreElements()) {
            JTable table = (JTable)enum1.nextElement();
            TableCellEditor editor = table.getCellEditor();
            if (editor == null) continue;
            editor.cancelCellEditing();
        }
        this.ascending = ascending;
        this.sortedColumn = column;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.reallocateIndexes();
        Object[] indexesObj = new Object[this.indexes.length];
        for (int i = 0; i < this.indexes.length; ++i) {
            indexesObj[i] = new Integer(this.indexes[i]);
        }
        int order = ascending ? 0 : 1;
        VWQuickTableSort sorter = new VWQuickTableSort(indexesObj, order, this.sortingColumns, this);
        sorter.sort(0, this.indexes.length - 1);
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i] = (Integer)indexesObj[i];
        }
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final VWTableSorter sorter = this;
        final JTable tableView = table;
        this.m_listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    if (!VWTableSorter.this.iModel.isColumnSortable(column)) {
                        return;
                    }
                    int selectedRow = VWTableSorter.this.getRowNumber(tableView.getSelectedRow());
                    int sortingOrder = VWTableSorter.this.iModel.getColumnSortingDirection(column);
                    boolean ascending = sortingOrder == 0;
                    sorter.sortByColumn(column, ascending);
                    sortingOrder = ascending ? 1 : 0;
                    VWTableSorter.this.iModel.setColumnSortingDirection(column, sortingOrder);
                    if (selectedRow != -1) {
                        selectedRow = VWTableSorter.this.getSortRowNumber(selectedRow);
                        tableView.setRowSelectionInterval(selectedRow, selectedRow);
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(this.m_listMouseListener);
        this.tables.add(table);
    }

    public void removeMouseListenerToHeaderInTable(JTable table) {
        JTable tableView = table;
        JTableHeader th = tableView.getTableHeader();
        th.removeMouseListener(this.m_listMouseListener);
    }

    public int getRowNumber(int aRow) {
        if (this.indexes != null && aRow != -1) {
            return this.indexes[aRow];
        }
        return aRow;
    }

    public int getSortRowNumber(int aRow) {
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] != aRow) continue;
            return i;
        }
        return -1;
    }

    public void removeReferences() {
        if (this.sortingColumns != null) {
            this.sortingColumns.removeAllElements();
            this.sortingColumns = null;
        }
        this.m_listMouseListener = null;
        this.model = null;
    }

    private void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }
}

